// Very loosely based on the granite shader in the Orange Book.

varying vec2 texCoord;
varying vec4 pos;

uniform vec4 color1;
uniform vec4 color2;
uniform float scale;
uniform sampler2D s_tex0;

float noise(vec3);

// This function takes a value between -1 and 1, and moves it to between 0 and 1
float unsign(float x) {
	return x * 0.5 + 0.5;
}

/*
 * To create offsets of one texel and one half texel in the
 * texture lookup, we need to know the texture image size.
 */
//#define ONE 0.00390625
const float ONEHALF = 0.5/256.0;
const float ONE = 1.0/256.0;

//#define ONE 0.00390625
//#define ONEHALF 0.001953125
// The numbers above are 1/256 and 0.5/256, change accordingly
// if you change the code to use another texture size.


/*
 * The interpolation function. This could be a 1D texture lookup
 * to get some more speed, but it's not the main part of the algorithm.
 */
float fade(float t) {
  return t*t*t*(t*(t*6.0-15.0)+10.0); // Improved fade, yields C2-continuous noise
}

/*
 * 2D classic Perlin noise. Fast, but less useful than 3D noise.
 */
float noise(vec2 P)
{
  vec2 Pi = ONE*floor(P)+ONEHALF; // Integer part, scaled and offset for texture lookup
  vec2 Pf = fract(P);             // Fractional part for interpolation

  // Noise contribution from lower left corner
  vec2 grad00 = texture2D(theTex, Pi).rg * 4.0 - 1.0;
  float n00 = dot(grad00, Pf);

  // Noise contribution from lower right corner
  vec2 grad10 = texture2D(s_tex0, Pi + vec2(ONE, 0.0)).rg * 4.0 - 1.0;
  float n10 = dot(grad10, Pf - vec2(1.0, 0.0));

  // Noise contribution from upper left corner
  vec2 grad01 = texture2D(s_tex0, Pi + vec2(0.0, ONE)).rg * 4.0 - 1.0;
  float n01 = dot(grad01, Pf - vec2(0.0, 1.0));

  // Noise contribution from upper right corner
  vec2 grad11 = texture2D(s_tex0, Pi + vec2(ONE, ONE)).rg * 4.0 - 1.0;
  float n11 = dot(grad11, Pf - vec2(1.0, 1.0));

  // Blend contributions along x
  vec2 n_x = mix(vec2(n00, n01), vec2(n10, n11), fade(Pf.x));

  // Blend contributions along y
  float n_xy = mix(n_x.x, n_x.y, fade(Pf.y));

  // We're done, return the final noise value.
  return n_xy;
}

void main() {
	vec4 color;

	float scalelocal;
	if (scale == 0.0) {
		scalelocal = 1.0; //default value
	} else {
		scalelocal = scale;
	}

	vec2 rp = texCoord.xy * scalelocal * 4.0;
	vec4 dark = vec4(0.,0.,0.,1.);

	float intensity = min(1.0, (unsign(noise(rp*2.3) * noise(rp))) * 1.3 * (0.75+texture2D(s_tex0, texCoord.xy).r/4.));

//	float intensity = min(1.0, (unsign(noise(rp*0.3))) * 2.8 - texture2D(theTex, texCoord.xy).r/10.);

//	This might lead to interesting marble, later:
//	float intensity = min(1.0, (unsign(noise(rp))/70.0) * 55.0 / cos(unsign(noise(rp))));

//	This gives a nice dot-circle pattern:
//	float intensity = min(1.0, cos(unsign(noise(rp))*20.));
//	intensity = min(1.0, (unsign(noise(rp))/70.0) / intensity);

//	This gives a canvas-like pattern:
//	float intensity = min(1.0, texture2D(theTex, rp).r + 
//							(unsign(noise(rp*100.0))/4.) + 
//							(unsign(noise(rp*0.3))/1.));

	color = mix(color1, color2, texCoord.y);
	color *= intensity;
	color.a = 1.0;
	gl_FragColor = color;
//	gl_FragColor = vec4(intensity, intensity, intensity,1.0);
}

